
DictNode=function(dict,parent,offset){
	if (parent) {
		this.parent=parent;
		this.root=parent.root;
		this.log=parent.log;
	} else {
		this.log=new Logger("DictNode");
//		this.log.disabled=1;
	}
	this.log.log("Create "+dict+","+parent+","+offset+";");
//	this.log.log=this.log.trace;
	this.log.log(this.log.log);
	var i;
	this.offset=0;
	if (offset) this.offset=offset;
	this.dict=dict;
//	this.nodes=new Array();
//	for(i=0;i<this.maxfields;i++)this.nodes[i]=this.empty;
}

DictNode.prototype.empty=new Object();
DictNode.prototype.maxfields=10;

DictNode.prototype.load = function(_f){
	var data = new Date()
	var data2
	var i;
	var n=0;
	var p=1
	var debug=9;
	var offsets;
	var line;
	var f;
	var s;
	if (!_f) {
		f=this.dict.dict_file; 
	} else f=_f;
	
	var log=this.log.enter("load",f.fsize+", "+(f.fsize-f.bytesAvailable)+", "+f.bytesAvailable+", "+this.offset)
	this.kombinacja=0
//	if (!_f) f=new Stream.File(this.dict.indexfile);
	if (this.dict.mode==2) {
		if (debug>3) this.log.log("Read node @ offset: "+this.offset);
		this.log.log("File position:",f.tell(),"bytes remaining",f.bytesAvailable);
		f.seek(this.offset);
//		this.log.log("File position:",f.tell(),"bytes remaining",f.bytesAvailable);
//		if (debug>3) this.log.log("load_node:Enter: "+f.fsize+", "+f.bytesAvailable+", "+this.offset)
		this.loaded=1;
	}
	s=f.readLine();
	this.log.log("loaded",s,"and now file position is",f.tell(),"and there are bytes remaining",f.bytesAvailable);
//	if (s==null){
//		this.log.log("ERROR: s is null");
//		s=f.readLine();
//		this.log.log("loaded",s,"and now file position is",f.tell(),"and there are bytes remaining",f.bytesAvailable);
//	}
	this.bitmap=parseInt(s)
	if (debug>3) this.log.log(this.bitmap)
	s=f.readLine();	//read parts, if they are present
	this.str=s;
	this.kombinacje=s.split(this.dict.parts_separator)
	this.log.log(this.str);
	this.log.log(this.kombinacje);
	if (this.dict.mode==2) {
		line=f.readLine();	//read any extra params 
		if (debug) this.log.log("Params: "+line)
		data2=line.split("/")	//read any extra params 
		if (debug) this.log.log("Params: ("+data2+"), "+data2.length)
		this.params=new Array()
		for(i=0;i<data2.length;i++){
			if (debug) this.log.log("    Params: ["+i+"]")
			if (debug) this.log.log("    Params: "+data2[i])
			this.params[i]=data2[i].toString().split(",")	//read any extra params 
		}
		if (debug) this.log.log("params: (" + this.params+")")
		if (this.bitmap) {
		       	offsets=f.readLine().split(' ')	//read offsets of child nodes
			if (debug) this.log.log("offsets: " + offsets);
		}else {
			if (debug) this.log.log("no more data");
//			if (!_f) f.close();
			if (debug>3) this.log.log("load_node Leave")
			return;
		}
	}

	this.nodes= new Array(this.maxfields);
//	this.log.log("array length: ",Math.log(this.bitmap)/Math.LN2);
	n=0;
	p=1;
	for(i=0;i<this.maxfields && p<=this.bitmap;i++) {
		if (debug) this.log.log("p&b: " + p + ", " + this.bitmap);
//		if (this.nodes.length<=i) this.nodes[i]=this.empty; 			if (this.bitmap & p) {
//			if (debug>5) this.log.log("Loading node " +i)
		if (this.bitmap & p) {
			this.nodes[i]=new DictNode(this.dict,this);
			if (this.dict.mode<2) this.nodes[i].load(f)	//if we're not in mode 2, then load child nodes
			else {
				this.nodes[i].offset=parseInt(offsets[n]);	//set only offsets otherwise
				if (debug>5) this.log.log("Child " + n +" offset: " + this.nodes[i].offset);
				n+=1;
			};
		}// else this.nodes[i]=this.empty; //assign a pointer to an empty object - it's faster and we need to assign something

		p=p<<1
	}
	data2= new Date()
	if (debug>3) this.log.log("load_node Leave")
//	if (debug) this.log.log("LoadNode: " + this.parent.howLong(data,data2))
//	if (!_f) f.close();
}

DictNode.prototype.kod=function(data){
	//od przerbki
	var log=this.log.enter("kod");
//	log.sync(1);
	try {
		log.log(data);
		log.log(data.charCodeAt(0));
		log.log(data.toUpperCase());
		log.log(data.toUpperCase().charCodeAt(0));
		
		var c=data.toUpperCase().charCodeAt(0);
		var c2;
//FIXME: more foolproofing - what if key is not found? what about symbols and space?
		if (c>=128) {
			log.log("found wierd char",c);
			c2=this.dict.translations[c.toString()]
			
			log.log("found wierd char",c,"changing to",c2);
			if (!c2) {
				c2=0xFF; //no such code...
				log.log("ERROR: character not found in translation table");
			}
			c=c2;
		}
		c-=0x41;
		if (c>=18) c--;	//S i wieksze
		if (c>=23) c--;
		var r=(c/3)|0;
		log.leave(c+","+r)
		log.async=1;
		return r+2;
	} catch(e) {log.error(e)};
//	log.async=1;
}


DictRoot=function(name){
	this.log=new Logger("DictRoot "+name);
	if (name) {
		this.name=name; 
		this.load();
	}
}

DictRoot.prototype.open=function(name){
	this.log.log("open "+name);
	if (!name) var name = this.name;
	if (this.dicts[name]) {
		this.log.log("already opened");
		this.log.log(this.dicts[name].root);
		return this.dicts[name].root;
	}
	var d = new DictRoot(name);
	if (!d.root) d.load(); else this.log.log("already loaded");
	this.dicts[name]=d;
	this.log.log("open leave");
	return d.root;
}

DictRoot.prototype.load=function(){
	this.log.log("Load enter");
	var debug=1
	var f
	var w,i,s
//	this.statusline.setValue("Loading...");
	var filename=this.name
	if (debug) this.log.log("Dict: "+this.opts.path+filename+".idx")
	
	try {
//		f=new Stream.File(this.path+filename+".idx")
		if (debug) this.log.log(File4);
		this.log.log("opening file",this.opts.path+filename+".idx")
		f=File4(this.opts.path+filename+".idx")
//		if (debug) this.log.log("Opened...")
//		if (debug) this.log.log(this.root)
		w=f.readLine().split(' ')
		if (debug) this.log.log("load "+w)
		this.mode=parseInt(w[1]);
//		if (w.length>2) this.maxpathsize=parseInt(w[2]);
		if (debug) this.log.log("load")
		for(i=2;i<w.length;i++) {
			s=w[i].split(":")
			if (debug) this.log.log("load " + w[i] +"|"+s)
			this[s[0]]=s[1]
			if (debug) this.log.log("load " + this[s[0]] +"|"+s[1])
		}
//		if (this.mode==1) this.parts_file=new Stream.File(this.path+filename+".idp");
		if (this.mode==1) this.parts_file=this.opts.path+filename+".idp";
		
//		this.load_node(f,this.root)
		if (debug) this.log.log("Create Root");
		this.root=new DictNode(this,null,f.tell());
		if (debug) this.log.log("Load Root");
		this.root.load(f);
//		this.dict_file=this.path+filename+".idx"
		this.dict_file=f;
		this.log.log("loading translations");
		this.translations={};
		//this can crash if file doesn't exist and it doesn't matter
		var path=this.opts.path+filename+".tra";
		var ft= new Stream.File(this.opts.path+filename+".tra");
		s=ft.toString();
		this.log.log(s);
		var fn = new Function("target", s, path, 1);
		fn(this.translations);
		delete fn;
		ft.close();
		this.log.leave();
//		this.statusline.setValue("OK");
	} catch (e) {
		this.log.log("load failed: "+e);
		this.log.log(e,"Load "+this.name);
//		this.statusline.setValue("Load failed");
	}
}

DictRoot.prototype.trace=target.trace;

//Dict = new DictRoot();

DictManager = new Object();
DictManager.init=function(){
	this.log= new Logger("DictManager");
	try {
		DictRoot.prototype.opts=new Options("dict");
		var opts=DictRoot.prototype.opts;
		this.opts=opts;
		var s;
		opts.load();
		this.log.log(opts.toString());
//	DictRoot.prototype.opts=new Options("dict");
//	DictRoot.prototype.opts.load();
		if (!opts.path) opts.path=GlobalOptions.dataroot+"/software/DICTIONARY/";
//		if (!opts.path) opts.path=GlobalOptions.dataroot+"/Sony Reader/software/DICTIONARY/";
//	Trace("DictRoot " + this.name +" Create");
		if (!this.dicts) {
			this.dicts=new Array();
			this.dicts.count=0;
		}
		this.DictRoot=new DictRoot();

//		Shell.runCommand(" cd \""+opts.path+"\" 2>&1>/tmp/dicts; pwd >>/tmp/dicts; ls >> /tmp/dicts");
/*
		Shell.runCommand(" cd "+opts.path.replace(/\s/g,"\ ")+"; ls *.idx> /tmp/dicts");
		this.log.log("/tmp/dicts",Shell.fileToString("/tmp/dicts"));
		var f = new Stream.File("/tmp/dicts");
		var dict;
		var first=0;

		while (f.bytesAvailable) {
			s=f.readLine().replace(".idx","");
			if (!first) first=s;
			this.log.log("Loading dict",s);
			dict = new DictRoot(s);
			if (FileSystem.getFileInfo(opts.path+s+".dic")) dict.hasContents=true;
			this.dicts[s]=dict;		//does not change length property...:/
			this.dicts.count++;
		}
*/
		var iter=new FileSystem.Iterator(opts.path);
		var fname=iter.getNext();
		while (fname) {
			this.log.log("processing",fname.path);
			if (fname.path.indexOf(".idx") >= 0){
				s=fname.path.replace(".idx","");
				if (!first) first=s;
				this.log.log("Loading dict",s);
				dict = new DictRoot(s);
				if (FileSystem.getFileInfo(opts.path+s+".dic")) dict.hasContents=true;
				this.dicts[s]=dict;		//does not change length property...:/
				this.dicts.count++;
			}
//			this.log.log("before");
			fname=iter.getNext();
//			this.log.log("after");
//			this.log.log(fname)
//			this.log.log(fname.path)
		}
		this.log.log("after loop");
		
//FIXME: create empty dict if there are none on the card and issue a warning
		if (!this.dicts.count) {
			this.log.log("ERROR: NO DICTIONARIES FOUND!!!",opts.path);
		}
		this.log.log("1");
		if (!opts.defaultDict) {
			this.log.log("No default dict set. Setting to",first);
			opts.defaultDict=first;
//			opts.save();
		}
		this.log.log("2");
		if (!this.dicts[opts.defaultDict]) {
			this.log.log("Default dict does not exist. Setting to",first);
			opts.defaultDict=first;
//			opts.save();
		}
		this.log.log("Options",opts.toString());
		this.log.log("options prototype",DictRoot.prototype.opts.toString());
	} catch(e) {this.log.error(e,"init")}
}

DictManager.open=function(name){
	var log = this.log.enter("open",name);
	try {
		if (!name) 
			var name = this.opts.defaultDict;
		else if (!this.dicts[name])var name = this.opts.defaultDict;
		
		if (this.dicts[name]) {
//			log.log(this.dicts[name].root);
			this.log.leave(this.dicts[name].root);
			return this.dicts[name].root;
		} else return null;

		var d = new DictRoot(name);
		if (!d.root) d.load(); else this.log.log("already loaded");
		this.dicts[name]=d;
		this.log.leave();
		return d.root;
	}catch(e) {log.error(e);}
}
DictManager.showSelectDictMenu=function(callback,withContentsOnly){
	var labels = [],values = [], i;
	var log = this.log.enter("showSelectDictMenu",callback,withContentsOnly);
	try {
		for(i in this.dicts) {
			log.log("processing",i,this.dicts[i] instanceof DictRoot,this.dicts[i].hasContents,);
			if (!(this.dicts[i] instanceof DictRoot)) continue;
			if (withContentsOnly && !this.dicts[i].hasContents) continue;
			log.log("push")
			values.push(i)
			log.log(this.dicts[i].description);
			if (this.dicts[i].description) 
				labels.push(this.dicts[i].description);
			else
				labels.push(i);
		}
		log.log("SelectBox",labels,values);
		SelectBox(labels,values,callback);
		log.leave();
	}catch(e) { log.error(e)}
}


DictWalker = function(name,parent){
	if (!name && !parent) return this;
	this.log=new Logger("DictWalker "+name);
	this.trace=this.log.trace;
	this.log.log(this.trace);
	this.kombinacja=0;
	this.keys="";
	this.root=DictManager.open(name);
	this.log.log(this.root);
	this.node=this.root;
	this.name=name;
	this.log.log("Root created");
	this.dict=this.root.dict;
	this.parent=parent;
	this.chain=[];
}

DictWalker.prototype.trace=target.trace;
DictNode.prototype.trace=target.trace;

//FIXME
DictWalker.prototype.goto_path=function(pth,fullword,follow){
	var log=this.log.enter("goto_path",pth,fullword,follow,this.keys);
	var i,s,start;
	var debug=1;
	var fullword = (fullword == null) ? 0 : fullword;
	var follow = (follow == null) ? 0 : follow;
	try {
//	if (!fullword) fullword=0;
		if (this.keys==pth) return this.node.kombinacje[this.kombinacja];
		if (follow) start=this.node.kombinacje[this.kombinacja];
		this.node=this.root;
		this.keys="";
		this.notfound=0;
		for(i=0;i<pth.length-1;i++) {
			log.log(i,pth.charAt(i),parseInt(pth.charAt(i)))
			this.doDigit(parseInt(pth.charAt(i)))
		}
		if (debug)log.log(i,pth.charAt(i),parseInt(pth.charAt(i)))
		s=this.doDigit(parseInt(pth.charAt(i)));
		if (debug) log.log("OK: ",s)
		i=0;
//FIXME: next doesn't return null, but blink - this will go into infinite loop;
		if (fullword && i<100) {
			while (this.node.params[this.kombinacja].length<2 && s) s=this.next();
			if (!s) return this.next();
			i++;
		}
		if (i==100) log.log("ERROR: infinite loop 1");
		i=0;
		if (follow && i<100) {
//		while (this.node.kombinacje[this.node.kombinacja].slice(0,start.length)!=start) s=this.next()
			while (s.slice(0,start.length)!=start && s) s=this.next();
			if (!s) return this.next();
			i++
		}
		if (i==100) log.log("ERROR: infinite loop 2");
		return s;
	} catch (e) {log.error(e);}
}

DictWalker.prototype.doMark=function(){
	var log = this.log.enter("doMark");
	try {
		SelectBox(this.node.kombinacje,[],{obj:this,method:"setElement"});
	}catch(e){log.error(e)}
}
DictWalker.prototype.setElement=function(obj){
	var log = this.log.enter("setElement");
	try {
		this.kombinacja=obj.index;
		log.log("index",obj.index,obj.label);
//		this.parent.showCursor();
		this.parent.UI.focus(true);
		log.leave();
	}catch(e){log.error(e)}
}

DictWalker.prototype.doMarkMenu=function(){
	var log = this.log.enter("doMarkMenu");
	try {
		DictManager.showSelectDictMenu({obj:this,method:"setDict"},this.parent.opts.dictsWithContentsOnly);
		log.leave();
	}catch(e){log.error(e)}
}

DictWalker.prototype.setDict=function(obj){
	var log = this.log.enter("setDict");
	try {
		if (!obj.value) obj.value=obj.label;
		if (obj.value==this.name) {
			log.leave("Dict not changed");
			this.parent.UI.focus(true);
			return 0;
		}
		log.log("Changing to",obj.value);
		if (this.parent.opts.multiword) {
			log.log("flushing");
			this.parent.flush();
		}
//FIXME: we should call the counstructor once again, and it should be ready for it
		this.kombinacja=0;
		this.notfound=0;
		this.keys="";
		this.root=DictManager.open(obj.value);
		log.log(this.root);
		this.node=this.root;
		this.name=obj.value;
		log.log("Root created");
		this.dict=this.root.dict;
	
		log.log("showCursor");
//		this.parent.showCursor();
		this.parent.UI.focus(true);
		log.leave();
	}catch(e){log.error(e)}
}

//FIXME - it should follow the word exactly and break if there's no such word in the dict (although there may be some word under this key combination
DictWalker.prototype.goto_word=function(dest){
	var log=this.log.enter("goto_word");
	var i,p="";
	log.log(dest);
	log.log(dest.length);
	this.node=this.root;
	this.keys="";
	try{
		for(i=0;i<dest.length;i++){
			log.log("i="+i);
			p=this.doDigit(this.root.kod(dest.charAt(i)));
			log.log(p);
			if (p.blink) {
				log.log("blink");
//				this.parent.UI.bubble("doBlink");
				break;
			}
		}
		log.log("end loop",this.keys.length);
		i=this.node.kombinacje.indexOf(dest.slice(0,this.keys.length));
		log.log(i);
		if (i>=0) {
			this.kombinacja=i;
			this.node.kombinacja=i;
			log.leave("Found "+this.current());
			return this.current();
		}
		log.leave("not found"+p);
		return p;
	} catch (e) {
		log.error(e);
	}	
}

DictWalker.prototype.current=function(){
	return this.node.kombinacje[this.kombinacja];
}

DictWalker.prototype.blink=function(){
	var s = new String(this.current()+"?");
	s.blink=1;
	this.notfound=1;
	return s;
}

DictWalker.prototype.next=function(){
	var log=this.log.enter("next");
	var debug=1;
	try {
		this.kombinacja++;
		if(this.kombinacja==this.node.kombinacje.length)
		{
			this.kombinacja=0;
			log.leave("at the end - setting to the first on");
			return this.blink();//.part;
		};	
		if (debug) log.log(this.kombinacja);
		if (debug) log.log(this.node.kombinacje.length);
		log.leave();
		if(this.kombinacja < this.node.kombinacje.length)	{
			return this.current();//.part;
		} else {
			return this.blink();
		};
	} catch (e) {log.error(e);}	
};
//DictWalker.prototype.doUp=DictWalker.prototype.next;
DictWalker.prototype.prev=function(){
	var log=this.log.enter("prev");
	var debug=1
	try {
		this.kombinacja--;
		if(this.kombinacja<0)
		{
			this.kombinacja=this.node.kombinacje.length-1;
			log.leave("at the beginning - setting to the last");
			return this.current();//.part;
		};	
		if (debug) log.log(this.kombinacja);
		if (debug) log.log(this.node.kombinacje.length);
		log.leave();
		if(this.kombinacja >= 0)
		{
			return this.current();
		} else {
			return this.blink();
		};
	} catch (e) {log.error(e);}	
};
//DictWalker.prototype.doDown=DictWalker.prototype.prev;

DictWalker.prototype.doDigit=function(key){
	var log=this.log.enter("doDigit",key);
	if (this.notfound) return this.blink();
	try {
		if (this.node==null) this.node=this.root;
		
		log.log("AL: " + this.node.bitmap +','+(1<<key));
//FIXME: this will bring out problems if this node is used with different combination of chianed dictionaries (it'll have .chained set and won't get the combinations)
		if (this.node.bitmap & (1<<key))
		{
			this.node=this.node.nodes[key];
			if (this.dict.mode==2 && !this.node.loaded) this.node.load();
			this.keys+=key.toString();
			log.log("keys: "+this.keys)
			this.kombinacja=0;
			log.leave(this.current());
			return this.current();
		}
		log.log("not found");
		log.leave("blink");
		return this.blink();
	} catch (e) {log.error(e);}

}
/*
DictWalker.prototype.doDigit=function(key){
	var debug=1
	var f;
	var s;
	var i,blink,c;
	var notfound=0;
	var notchained=1;
	var log=this.log.enter("doDigit",key);
	if (this.notfound) return this.blink();
	try {
		if (this.node==null) this.node=this.root;
		
		if (debug) log.log("AL: " + this.node.bitmap +','+(1<<key));
//FIXME: this will bring out problems if this node is used with different combination of chianed dictionaries (it'll have .chained set and won't get the combinations)
		if (this.node.bitmap & (1<<key))
		{
			this.node=this.node.nodes[key];
			if (this.dict.mode==2 && !this.node.loaded) this.node.load();
			this.keys+=key.toString();
			if (debug) log.log("keys: "+this.keys)
			this.kombinacja=0;
		}else {
			log.log("not found");
			notfound=1;
		};
		if (this.chain.length) {		//this way we get chained parts only once (and those dicts are read_only) 
			this.node.c_kombinacje=[];
			this.node.chained=1;
			for(c=0;c<this.chain.length;c++) {
				this.chain[c].doDigit(key);
				if (!this.chain[c].notfound) this.node.c_kombinacje.concat(this.chain[c].node.kombinacje);
			}
		} else {
			//not chained walker, go as before
			if (notfound) {
				log.leave("blink");
				return this.blink();
			} else {
				log.leave(this.current());
				return this.current();
			}
		}

//			return null;
	} catch (e) {
		log.error(e);
	}

}


*/
//do napisania
DictWalker.prototype.getBuf=function(noflush){
	var s;
	var log=this.log.enter("getBuf",noflush);
	try{
		if (this.keys=="") return "";
		s=this.current();
		if (noflush) {
			log.leave("no flushing:" + s);
		} else {
			log.log(this.node);
			log.log(this.node.kombinacje);
			log.log(this.kombinacja);
			this.node=this.root;
			this.keys="";
			log.leave("flushing "+s);
		}
		return s;
	}catch(e) {log.error(e);}
}
//musi pamietac case w osobnym polu, bo cala tresc bufora moze sie zmieniac. Sa trzy opcje - duza, mala i nie zmienia(dynamic i nie force)
DictWalker.prototype.setCase=function(data) {
}

//moglby dziedziczyc
DictWalker.prototype.getCase=function(data) {
	var log=this.log.enter("getCase");
	try {
		switch (this.parent.textCase) {
			case this.parent.CLOWER:
				return -1;
				break;
			case this.parent.CUPPER:
				return 1;
				break;
			case this.parent.CDYNAMIC:
				return this.parent.forceUpperCase;
				break;
		}
		log.leave();
	} catch(e) {log.error(e);}
}

//to moglby dziedziczyc, ale w zasadzie ton ie ma co...
DictWalker.prototype.showCursor=function() {
	var log = this.log.enter("showCursor",this.keys.length,this.keys,this.node.kombinacje[this.kombinacja]);
	try {
		if (this.parent.isFocused)
			if (!this.parent.isFocused()) return this.current();
		log.log(1);	
		if(this.keys=="") {
			return "*";
		};
		log.log(2);	
		var s=this.current()+(this.notfound ? "?":"")
		log.log(s);	
		if (this.parent.opts.multiword) return "["+s+"]";
			else if (this.notfound) return s; 
			else return s+"*";
	}catch (e) {log.error(e);}
}

DictWalker.prototype.extractWord=function(dir){
	this.log.log("extractWord enter");
	var d=this.parent.pos;
	var d2=this.parent.pos;
//	this.buf=this.parent.buf;
	try{
		while (d>0 && d<this.parent.buf.length && this.parent.buf.charCodeAt(d)>0x40){
			d+=dir;
		}
		if (d<d2)
			return this.parent.extract(d,d2);
		else
			return this.parent.extract(d2,d);
	} catch (e) {this.log.error(e,"extractWord");}
}
DictWalker.prototype.doMove=function(dir){
	var log = this.log.enter("doMove");// enter");
	try {
		log.log(this.notfound);
		if (this.notfound){
			this.notfound=0;
			if (dir==1 && this.parent.opts.multiword) this.parent.flush();
			return true;
		}
		log.log("Part 2");
		log.log(this.keys);
		log.log(this.keys.length);
		log.log(this.parent);
		log.log("Part 2.2");
		log.log(this.parent.buf);
		log.log(this.parent.opts);
		log.log(this.parent.opts.multiword);
		log.log(this.parent.pos);
		
		if (this.keys.length){
			if (!this.parent.opts.multiword) return true;
			var pos=this.parent.pos;
			this.parent.flush();
			if (dir==-1) this.parent.pos=pos;
			return true;
		}
		log.log("Part 3");
		log.log(this.parent.buf.charAt(this.parent.pos));
		log.log(this.parent.buf.charAt(this.parent.pos-1));
		switch (dir) {
			case -1 : if (this.parent.buf.charCodeAt(this.parent.pos-1)<0x41) {
					this.parent.pos--;
					return true;
				} else {
					//tu mamy cale slowo
					return true;
				}
			case 1 : if (this.parent.buf.charCodeAt(this.parent.pos)<0x41) {
					this.parent.pos++;
				} else {
					//we go right - if we have a letter under cursor, it meand that we're gonna edit the word now
					return true;
				}
				break;
		}
	}catch(e) {log.error(e)};
	return false;
}

DictWalker.prototype.doDelete=function(dir,len){
	var log = this.log.enter("doDelete",dir,len);// enter");
	try {
		log.log(this.notfound);
		
		if (this.notfound){
			if (len && len>this.keys.length) return;		//for SuperDictWalker
			this.notfound=0;
			if (dir==1 && this.parent.opts.multiword) this.parent.flush();
			return true;
		}
		if (!this.keys.length) return false;		//dont care if the buffer is empty
		if (dir==1) return !this.parent.opts.multiword;	//if no multiword, than go on, but in singleword (i.e. Dictionary, do nothing)
		
		var i,t;
		var debug=0;
		log.log(this.node);
		log.log(this.node.parent);
		log.log(this.node.kombinacje);
		if(!this.node || !this.node.parent) return true;
		this.keys=this.keys.slice(0,-1)
		t=this.node.kombinacje[this.kombinacja].slice(0,-1)
		this.node=this.node.parent
		log.log(this.node.parent);
		if(!this.node.parent) return true;

//FIXME: zamienic na indexOf()
		log.log(this.node.kombinacje);
		for(i=0;i<this.node.kombinacje.length;i++) if (t==this.node.kombinacje[i]) break;
		log.log(i);
		if (i<0 || i>=this.node.kombinacje.length) i=0;
		log.log(i);

		this.kombinacja=i;
		log.log(i);
		this.node.kombinacja=i;
		log.log(i);
		return this.current();
	}catch(e) {log.error(e);}
	return false;
}

DictWalker.prototype.getFullPath=function(){
	var s;
	var debug=1;
	var log=this.log.enter("getFullPath");
	var f;
	try {
		f= File4(this.dict.opts.path+this.dict.name+".pth")
		if (debug) log.log("seek",this.node.params[this.kombinacja][0])
		f.seek(parseInt(this.node.params[this.kombinacja][0]))
		if (!f.bytesAvailable) log.log("ERROR: EOF reached")
		s=f.readLine();	
		log.leave(s)
		f.close();
		return s;
	}catch(e) {log.error(e)};
}

DictWalker.prototype.setBuf=function(buf){
	var s;
	var debug=1;
	var log=this.log.enter("setBuf");
	try {
		log.log(buf);
		s=this.goto_word(buf)
		return s;
	}catch(e) {log.error(e)};
}



DictWalker.prototype.getContents=function(){
	var log = this.log.enter("getContents");
	var debug=1;
	var f,s,maxlines=12;
	try{
		this.notfound=0;
		if (debug) log.log("getWord:" + this.node.params+")");
		if (this.node.params[0]=='-') return null;
		if (debug) log.log("getWord:"+this.node.params.length+", "+this.kombinacja+", "+this.node.params[this.kombinacja]+", "+this.node.params[this.kombinacja].length )
		
	//	s=this.getFullPath();
		if (this.node.params[this.kombinacja].length==1){
			s=this.getFullPath();
			this.goto_path(s,0,1);
		}
		log.log(this.current());
//		if (!this.datafile) {
			if (debug) log.log("open:"+this.dict.opts.path+this.name+".dic")
			f = File4(this.dict.opts.path+this.name+".dic")
//		}
//		f=this.datafile
		if (debug) log.log("seek")
		f.seek(parseInt(this.node.params[this.kombinacja][1]));
		if (debug) log.log("read");
		s=f.readLine();
		f.close();
		log.log(s);
		log.leave();
		return s;
/*
		if (debug) log.log("getWord:breakLines (" + lines+")");

		var n=0;
		while (n<=maxlines && n<lines.length) 
		{
			if (debug) log.log("getWord:tT"+n.toString());
			this["tT"+n.toString()].setValue(lines[n]);
			n++;
		}
		while (n<=maxlines) {
			this["tT"+n.toString()].setValue("");
			n++;
		}
		*/
	} catch (e) {
		log.error(e);
	}
}

DictWalker.prototype.nextWord=function(dir){
	var log=this.log.enter("nextWord",dir);
	try{
		var s,offset,n,old_path;
		var debug=1;
		var f;
		f= File4(this.dict.opts.path+this.dict.name+".pth")
		if (this.node.params[this.kombinacja].length==1){			//not a whole word
			if (debug) log.log("Partial word",this.current());
			if (dir==1) {																			//if we go forward, just display the whole word
//			this.dict.goto_path(s);
				s=this.getFullPath();
				log.log(s)
				this.goto_path(s,0,1);
				log.leave(this.current());
				return 0;
			};// else s=this.getPath();
		};// else{
//		old_path= this.getPath()

//		if (!this.pathsfile) {
//			if (debug) log.log("file not open");
//			this.getFullPath();
//		}
		offset=parseInt(this.node.params[this.kombinacja][0])		//seek to present path
		if (debug) log.log("seek",offset);
		f.seek(offset)
		if (debug) log.log("OK",f.tell());

		if (dir==1) {
			if (debug) log.log("readline");
			f.readLine();												//throw away current path
			oldoffset=f.tell();
			if (f.bytesAvailable) {
				if (debug) log.log("OK",f.tell());
				s=f.readLine();		//read next if there's one
			} else {
				if (debug) log.log("ERROR: EOF  Leave\n");
				return null;
			}
			if (debug) log.log(s,f.tell());
		} else {		//sarching backwards
			offset=f.tell();
			n=-this.dict.maxpathsize-5;
			if (debug) log.log("nextWord: seek "+offset+", "+n);
			if (-n>offset) n=-offset;
			if (debug) log.log("nextWord: seek "+offset+", "+n);
//		this.pathsfile.seekold(n)
			f.seek(offset+n)
			if (debug) log.log("nextWord: OK");
			while (f.tell()<offset && f.bytesAvailable) {
				oldoffset=f.tell();
				s=f.readLine();
				if (debug) log.log("nextWord: " + s +", "+f.tell());
			}
			if (debug) log.log("nextWord: OK");
			if (!f.bytesAvailable) log.log("nextWord err: EOF reached")
		};
		
		if (debug) log.log("goto_path ",s,1);
		var old_s=s;
		s=this.goto_path(s,1);
//	if (this.getPath()==old_path){
			while (this.node.params[this.kombinacja][0] != oldoffset  && !s.blink) s=this.next(); //this.dict.node.params[this.dict.kombinacja].length==1
			if (s.blink) s=this.goto_path(old_s,1);
//	}
				
//		log.log("getWord ",s);
//		this.getWord()
		log.leave(s);
		f.close();
		return this.current();
	} catch (e) {log.error(e);}
}


DictSuperWalker = function(){
	this.log=new Logger("DictSuperWalker");
	this.kombinacja=0;
	this.keys="";
	this.node=this;
	this.root=this;
}

DictSuperWalker.inherits(DictWalker);

DictSuperWalker.prototype.doDigit=function(key){
	var log=this.log.enter("doDigit",key);
	if (this.notfound) return this.blink();
	try {
//FIXME: przerobic tak, zeby najpierw przechodzil i zbieral ilosc kombinacji, a potem tworzyl tablice o zadanej dlugosci i zbieral kombinacje
		var c_kombinacje=[];
		for(c=0;c<this.chain.length;c++) {
			this.chain[c].doDigit(key);
			if (!this.chain[c].notfound) c_kombinacje.concat(this.chain[c].node.kombinacje);
		}
		if (!c_kombinacje.length) {
			this.notfound=1;
			return this.blink();		//no more words in any dictionary
		}
		this.keys+=key.toString();
		log.log("keys: "+this.keys)
		this.kombinacje=c_kombinacje;
		this.kombinacja=0;
		log.leave(this.current());
		return this.current();		
	} catch(e) {log.error(e);}
}

DictSuperWalker.prototype.doDelete=function(dir){
	var log=this.log.enter("doDelete",dir);
	try {
		if (this.notfound){		//this could be done with uber
			this.notfound=0;
			if (dir==1 && this.parent.opts.multiword) this.parent.flush();
			return true;
		}
		if (!this.keys.length) return false;
		
		this.keys=this.keys.slice(0,-1);
		for(c=0;c<this.chain.length;c++) {
			this.chain[c].doDelete(key,this.keys.length);
			if (!this.chain[c].notfound) c_kombinacje.concat(this.chain[c].node.kombinacje);
		}
	} catch(e) {log.error(e);}
}


DictManager.init();
